/*---------------------------------------------------------------------------*\

    FILE....: PORT.H
    TYPE....: C++ Header
    AUTHOR..: David Rowe
    DATE....: 14/11/97

    Low level port I/O module interface.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __PORT__
#define __PORT__

#include "contypes.h"

/*-------------------------------------------------------------------------*\

			   MODULE INTERFACE

\*-------------------------------------------------------------------------*/

// generic port base class, functions are virtualised depending on
// operating system

class Port {
public:
    virtual void addBoard(USHORT base, USHORT span) = 0;
    virtual void write(USHORT board, USHORT offset, word value) = 0;
    virtual void blockWrite(USHORT board, USHORT offset, USHORT length, 
			    word *buf) = 0;
    virtual void blockRead(USHORT board, USHORT offset, USHORT length, 
			   word *buf) = 0;
};

// User Mode I/O implementation ------------------------------------------

class PortUser : public Port {
    PortUser *d;
public:
    PortUser();
    virtual ~PortUser();
    void addBoard(USHORT base, USHORT span);
    void write(USHORT board, USHORT offset, word value);
    void blockWrite(USHORT board, USHORT offset, USHORT length, word *buf);
    void blockRead(USHORT board, USHORT offset, USHORT length, word *buf);
};

// Linux implementation ------------------------------------------

class PortDataLinux;

class PortLinux : public Port {
    PortDataLinux *d;
public:
    PortLinux();
    virtual ~PortLinux();
    void addBoard(USHORT base, USHORT span);
    void write(USHORT board, USHORT offset, word value);
    void blockWrite(USHORT board, USHORT offset, USHORT length, word *buf);
    void blockRead(USHORT board, USHORT offset, USHORT length, word *buf);
};

#endif	/* #ifndef __PORT__	*/

